#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from Toggles.QosToggleLib import togglePfcPacketBufferSplitPoolsEnabled
import Tac

PfcPoolAllocationPercent = Tac.Type( 'Pfc::PoolAllocationPercent' )

pfcPbProfileConfig = 'Qos.pfcPbProfileConfig'
CliSave.GlobalConfigMode.addCommandSequence( pfcPbProfileConfig )

@CliSave.saver( 'Pfc::PacketBufferProfileConfig',
                'dcb/pfc/packetBufferProfile/config' )
def saveConfig( entity, root, requireMounts, options ):
   """Save Pfc::PacketBufferProfileConfig"""
   if not togglePfcPacketBufferSplitPoolsEnabled():
      return

   cmds = root[ pfcPbProfileConfig ]
   pfcPbpConfig = entity

   saveAll = options.saveAll

   poolAllocationPercent = pfcPbpConfig.poolAllocationPercent
   cmd = 'priority-flow-control packet-buffer allocation'
   if poolAllocationPercent != PfcPoolAllocationPercent() or saveAll:
      cmds.addCommand( f'{cmd} lossless {poolAllocationPercent.lossless} percent '
                       f'headroom {poolAllocationPercent.headroom} percent' )
