# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliSave
import Tac

from CliSavePlugin.RouterGeneralCliSave import RouterGeneralVrfCliSaveMode
from CliSavePlugin.RouterGeneralCliSave import getRouterGeneralVrfModeCtx
from Toggles import RcfLibToggleLib

# pkgdeps: library RouteControl

RouteControlConstant = Tac.Type( 'Routing::RouteControl::Constant' )
 
RouterGeneralVrfCliSaveMode.addCommandSequence( 'ribRouteControl', 
                                                after=[ 'routes.dynamic' ] )

@CliSave.saver( 'Routing::RouteControl::Config',
                'routing/general/config/routeControl' )
def saveRibRouteControlConfig( entity, root, requireMounts, options ):
   if not len( entity.vrfConfig ): # pylint: disable=use-implicit-booleaness-not-len
      return

   for vrfName, vrfConf in entity.vrfConfig.items():
      vrfMode = getRouterGeneralVrfModeCtx( root, vrfName )
      cmds = vrfMode[ 'ribRouteControl' ]

      # Save ipv4 fib policy
      if vrfConf.fibIpv4Policy.mapOrRcf != RouteControlConstant.policyDefault:
         if ( RcfLibToggleLib.toggleRcfFibPolicyEnabled() and
              vrfConf.fibIpv4Policy.rcf ):
            cmds.addCommand( 'rib ipv4 fib policy rcf %s()' %
                             vrfConf.fibIpv4Policy.mapOrRcf )
         else:
            cmds.addCommand( 'rib ipv4 fib policy %s' %
                             vrfConf.fibIpv4Policy.mapOrRcf )
      elif options.saveAll:
         cmds.addCommand( 'no rib ipv4 fib policy' )

      # Save ipv6 fib policy
      if vrfConf.fibIpv6Policy.mapOrRcf != RouteControlConstant.policyDefault:
         if ( RcfLibToggleLib.toggleRcfFibPolicyEnabled() and
              vrfConf.fibIpv6Policy.rcf ):
            cmds.addCommand( 'rib ipv6 fib policy rcf %s()' %
                             vrfConf.fibIpv6Policy.mapOrRcf )
         else:
            cmds.addCommand( 'rib ipv6 fib policy %s' %
                             vrfConf.fibIpv6Policy.mapOrRcf )
      elif options.saveAll:
         cmds.addCommand( 'no rib ipv6 fib policy' )

      # Save ipv4 resolution policy
      if vrfConf.resIpv4PolicyMap != RouteControlConstant.policyDefault:
         saveCmd = 'rib ipv4 resolution policy %s' % vrfConf.resIpv4PolicyMap
         cmds.addCommand( saveCmd )
      elif options.saveAll:
         cmds.addCommand( 'no rib ipv4 resolution policy' )

      # Save ipv6 resolution policy
      if vrfConf.resIpv6PolicyMap != RouteControlConstant.policyDefault:
         saveCmd = 'rib ipv6 resolution policy %s' % vrfConf.resIpv6PolicyMap
         cmds.addCommand( saveCmd )
      elif options.saveAll:
         cmds.addCommand( 'no rib ipv6 resolution policy' )
