# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave
from CliSavePlugin.RouterGeneralCliSave import RouterGeneralCliSaveMode

ecmpState = Tac.Type('Routing::General::StaticRouteEcmpState')

@CliSave.saver( 'Routing::General::Config', 'routing/general/config/global' )
def saveStaticRouteEcmpStateConfig( entity, root, requireMounts, options ):

   saveAll = options.saveAll

   mode = root[ RouterGeneralCliSaveMode ].getSingletonInstance()
   cmds = mode[ 'config' ]

   cmdStr = 'route ecmp static relaxed'
   if entity.staticRouteEcmpState != ecmpState.strict:
      cmds.addCommand( cmdStr )
   elif saveAll:
      cmds.addCommand( "no " + cmdStr )
