# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave
from CliSavePlugin.RouterGeneralCliSave import (
      RouterGeneralCliSaveMode,
      getRouterGeneralVrfMode
   )

defaultStaticResRibConfig = Tac.Value( 
      "Routing::Rib::ResolutionRibProfileConfig" )

@CliSave.saver( 'Routing::General::Config', 'routing/general/config/global' )
def saveStaticResRibConfig( entity, root, requireMounts, options ):

   saveAll = options.saveAll

   mode = root[ RouterGeneralCliSaveMode ].getSingletonInstance()
   for vrfName in sorted( entity.vrfConfig ):
      vrfMode = getRouterGeneralVrfMode( mode, vrfName )
      vrfCmds = vrfMode[ 'vrfConfig' ]
      vrfEntity = entity.vrfConfig[ vrfName ]

      if vrfEntity.staticResRibProfileConfig != defaultStaticResRibConfig:
         # pylint: disable-next=consider-using-f-string
         vrfCmds.addCommand( 'route static next-hop resolution ribs %s' %
                              vrfEntity.staticResRibProfileConfig.stringValue() )
      elif saveAll:
         vrfCmds.addCommand( 'no route static next-hop resolution ribs' )
