# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.RouterGeneralCliSave import RouterGeneralCliSaveMode

@CliSave.saver( 'Routing::Hardware::Config',
                'routing/hardware/config' )
def saveDynPolicyRoutesConfig( entity, root, requireMounts, options ):
   saveAll = options.saveAll
   mode = root[ RouterGeneralCliSaveMode ].getSingletonInstance()
   cmds = mode[ 'config' ]

   cmdStr = 'hardware next-hop fast-failover'
   if entity.hwFastFailoverEnabled:
      cmd = cmdStr
      cmds.addCommand( cmd )
   elif saveAll:
      cmd = "no " + cmdStr
      cmds.addCommand( cmd )
