# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

serviceConfigCmdSeqName = "SysMgr.serviceConfig"

CliSave.GlobalConfigMode.addCommandSequence( serviceConfigCmdSeqName )

@CliSave.saver( "System::ServiceConfig", 'sys/service/config' )
def saveConfig( config, root, requireMounts, options ):
   cmds = root[ serviceConfigCmdSeqName ]
   saveAll = options.saveAll

   if config.timeInRunningConfig != config.timeInRunningConfigDefault:
      cmds.addCommand( "service running-config timestamp" )
   elif saveAll:
      cmds.addCommand( "no service running-config timestamp" )

   if config.runningConfigCacheDisabled != config.runningConfigCacheDisabledDefault:
      cmds.addCommand( "service running-config cache disabled" )
   elif saveAll:
      cmds.addCommand( "no service running-config cache disabled" )

   if ( config.useSessionInCopyRunningConfig !=
        config.useSessionInCopyRunningConfigDefault ):
      cmds.addCommand( "service running-config copy use-config-session" )
   elif saveAll:
      cmds.addCommand( "no service running-config copy use-config-session" )
