#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSave import escapeFormatString
import Tac

from CliMode.SharedSecretProfileMode import SharedSecretProfileCliMode
from CliSavePlugin.Security import SecurityConfigMode
from CliSavePlugin.Security import mgmtSecurityConfigPath
import ReversibleSecretCli
from TypeFuture import TacLazyType
import Toggles.MgmtSecurityToggleLib as MgmtSecurityToggle
from SharedSecretProfileLib import LifetimeHelper

SecretConfigLocation = TacLazyType(
   'Mgmt::Security::SharedSecretProfile::SecretConfigLocation' )

class SharedSecretProfileMode( SharedSecretProfileCliMode, CliSave.Mode ):
   def __init__( self, param ):
      SharedSecretProfileCliMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

SecurityConfigMode.addChildMode( SharedSecretProfileMode,
                                 after=[ 'Mgmt.security' ] )
SharedSecretProfileMode.addCommandSequence(
   'Mgmt.security.sh-sec-prof.profile' )
SharedSecretProfileMode.addCommandSequence(
   'Mgmt.security.sh-sec-prof' )

@CliSave.saver( 'Mgmt::Security::SharedSecretProfile::Config',
                'mgmt/security/sh-sec-prof/config',
                requireMounts=( mgmtSecurityConfigPath, ) )
def saveSharedSecretProfileConfig( entity, root, requireMounts, options ):
   mode = root[ SecurityConfigMode ].getSingletonInstance()
   cmds = mode[ 'Mgmt.security' ]
   if ( entity.secretLocation != entity.defaultSecretLocation or
        options.saveAll and MgmtSecurityToggle.toggleHideSecretsEnabled() ):
      cmd = 'session shared-secret hidden'
      if entity.secretLocation == SecretConfigLocation.memoryOnly:
         cmd += ' memory-only'
      elif entity.secretLocation == SecretConfigLocation.encryptedConfig:
         cmd += ' encrypted-config'
      else:
         cmd = 'no ' + cmd
      cmds.addCommand( cmd )
   for name, profile in entity.profile.items():
      secMode = root[ SecurityConfigMode ].getSingletonInstance()
      mode = secMode[ SharedSecretProfileMode ].getOrCreateModeInstance( name )
      cmds = mode[ 'Mgmt.security.sh-sec-prof.profile' ]

      securityConfig = requireMounts[ mgmtSecurityConfigPath ]
      for secret in sorted( profile.secret.values() ):
         formatStr = (
            f'secret {escapeFormatString(secret.id)} '
            '{} receive-lifetime '
            f'{escapeFormatString(LifetimeHelper.toString(secret.receiveLifetime))} '
            'transmit-lifetime '
            f'{escapeFormatString(LifetimeHelper.toString(secret.transmitLifetime))}'
         )

         cmds.addCommand( ReversibleSecretCli.getCliSaveCommand( formatStr,
                                                                 securityConfig,
                                                                 secret.secret,
                                                                 algorithm='DES' ) )
