# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import natsort

import CliSave

speedGroupSeqName = 'SpeedGroup.config'
CliSave.GlobalConfigMode.addCommandSequence( speedGroupSeqName )

@CliSave.saver( 'Tac::Dir', 'interface/archer/config/eth/phy/speedgroup/slice' )
def saveSpeedGroupConfig( sliceDir, root, requireMounts, options ):
   cmds = root[ speedGroupSeqName ]
   enumToToken = { 'compatibility10g' : '10g',
                   'compatibility25g' : '25g',
                   'compatibility50g' : '50g',
                   'compatibility100g' : '100g' }
   for speedGroupConfigDir in sliceDir.values():
      for speedGroup, speedGroupConfig in natsort.natsorted(
            speedGroupConfigDir.group.items() ):
         compatibilities = []
         for compatibility in speedGroupConfig.setting:
            # Unknown isn't a valid compatiblity setting, so just ignore it when
            # trying to save the tokens.
            if compatibility == 'compatibilityUnknown':
               continue
            compatibilities.append( enumToToken[ compatibility ] )
         compatString = ' '.join( compatibilities )
         if compatString:
            # pylint: disable-next=consider-using-f-string
            cmds.addCommand( 'hardware speed-group%s serdes %s' % ( speedGroup,
                                                                    compatString ) )
         elif options.saveAll:
            # pylint: disable-next=consider-using-f-string
            cmds.addCommand( 'no hardware speed-group%s serdes' % speedGroup )

CliSave.GlobalConfigMode.addCommandSequence( 'Interface.speedGroupAutoMode' )

@CliSave.saver( 'Interface::EthPhyIntfGlobalDefaultConfigDir',
                'interface/config/eth/phy/globalDefault' )
def saveSpeedGroupAutoMode( entity, root, requireMounts, options ):
   cmds = root[ 'Interface.speedGroupAutoMode' ]
   if entity.speedGroupAutoMode:
      cmds.addCommand( 'hardware speed-group default single-slot auto' )
   elif options.saveAll:
      cmds.addCommand( 'no hardware speed-group default single-slot auto' )
