# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module defines the CLI save mode for all system wide L1 parameters.'''

from ArPyUtils.Types import ArException
from CliMode.SystemL1 import SystemL1Mode
import CliSave

class SystemL1SaveMode( SystemL1Mode, CliSave.Mode ):
   def __init__( self, param ):
      if param is not None:
         raise ArException( 'System l1 mode is a global mode, and cannot use named '
                            'instances.',
                            param=param )

      SystemL1Mode.__init__( self )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( SystemL1SaveMode )

SystemL1SaveMode.addCommandSequence( 'SystemL1.terminal' )

@CliSave.saver( 'Interface::EthPhyIntfGlobalDefaultConfigDir',
                'interface/config/eth/phy/globalDefault',
                hasDefaultConfig=True )
def saveXcvrCapVerificationBypass( globalDefault, root, requireMounts, options ):
   systemL1SaveMode = root[ SystemL1SaveMode ].getSingletonInstance()
   cmds = systemL1SaveMode[ 'SystemL1.terminal' ]

   if globalDefault.xcvrCapVerificationBypass.speed:
      cmds.addCommand( 'unsupported speed action warn' )
   elif options.saveCleanConfig:
      cmds.addCommand( 'unsupported speed action error' )

   if globalDefault.xcvrCapVerificationBypass.errorCorrection:
      cmds.addCommand( 'unsupported error-correction action warn' )
   elif options.saveCleanConfig:
      cmds.addCommand( 'unsupported error-correction action error' )
