#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin import Management
from CliMode.TechSupport import TechSupportPolicyMode

class TechSupportConfigMode( Management.MgmtConfigMode ):
   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, "tech-support" )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( TechSupportConfigMode )
TechSupportConfigMode.addCommandSequence( 'Mgmt.tech-support' )

class TechSupportPolicyConfigMode( TechSupportPolicyMode, CliSave.Mode ):
   def __init__( self, param ):
      TechSupportPolicyMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

TechSupportConfigMode.addChildMode( TechSupportPolicyConfigMode )
TechSupportPolicyConfigMode.addCommandSequence( 'Mgmt.tech-support.policy' )

@CliSave.saver( 'Cli::Config', 'cli/config' )
def saveTechSupport( techSupportConfig, root, requireMounts, options ):
   mode = root[ TechSupportConfigMode ].getSingletonInstance()
   mode = mode[ TechSupportPolicyConfigMode ].getOrCreateModeInstance(
      'show tech-support' )
   cmds = mode[ 'Mgmt.tech-support.policy' ]
   for c in sorted( techSupportConfig.excludedShowTechCmds ):
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'exclude command %s' % c )
   for c in sorted( techSupportConfig.excludedShowTechJsonCmds ):
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'exclude command json %s' % c )
   for c in sorted( techSupportConfig.includedShowTechCmds ):
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'include command %s' % c )
