# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import Tac, CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'ObjectTracking.config' )

@CliSave.saver( 'Tracking::Config', 'tracking/config' )
def saveTrackingCliConfig( entity, root, requireMounts, options ):
   cmds = root[ 'ObjectTracking.config' ]
   for intfObjConfig in entity.interfaceObjectConfig.values():
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'track %s interface %s line-protocol'
                       % (intfObjConfig.name, intfObjConfig.intfName) )
