# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-in
# pylint: disable=consider-using-f-string

from __future__ import absolute_import, division, print_function

import CliSave
import Tac
from CliMode.TunnelRib import TunnelRibsBaseMode, TunnelRibBaseMode, \
                              tunnelTableIdToCliToken
import Toggles.TunnelToggleLib
from Toggles import IpLibToggleLib
ProtoPrefAction = Tac.Type( "Tunnel::TunnelTable::ProtoPrefAction" )
TunnelTableIdentifier = Tac.Type( "Tunnel::TunnelTable::TunnelTableIdentifier" )

class TunnelRibsConfigMode( TunnelRibsBaseMode, CliSave.Mode ):
   def __init__( self, param ):
      TunnelRibsBaseMode.__init__( self )
      CliSave.Mode.__init__( self, param )

class TunnelRibConfigMode( TunnelRibBaseMode, CliSave.Mode ):
   def __init__( self, tunnelRibName ):
      TunnelRibBaseMode.__init__( self, tunnelRibName )
      CliSave.Mode.__init__( self, tunnelRibName )

CliSave.GlobalConfigMode.addChildMode( TunnelRibsConfigMode )
TunnelRibsConfigMode.addChildMode( TunnelRibConfigMode )
TunnelRibConfigMode.addCommandSequence( "TunnelRib.config" )

def saveTunnelRib( tunnelRib, prefStringDefault,
                   igpCostStringDefault, trsMode, colored=False ):
   tunnelRibName = 'colored ' if colored else ''
   tunnelRibName += tunnelRib.name
   mode = trsMode[ TunnelRibConfigMode ].getOrCreateModeInstance( tunnelRibName )
   cmds = mode[ "TunnelRib.config" ]
   for entry in tunnelRib.entry.values():
      prefString = prefStringDefault
      igpCostPrefString = igpCostStringDefault
      
      # Remove when toggle not required, it was intially for bug BUG423489
      if (entry.tunnelTableId == TunnelTableIdentifier.ospfSrTunnelTable and 
         not Toggles.TunnelToggleLib.toggleOspfSegmentRoutingTunnelEnabled()):   
         continue
      if entry.prefMapping.action == ProtoPrefAction.prefStatic:
         prefString = " preference %d" % entry.prefMapping.staticPref
      if entry.igpCostPrefMapping.action == ProtoPrefAction.prefStatic:
         igpCostPrefString = " igp-cost preference %d" \
               % entry.igpCostPrefMapping.staticPref
      cmds.addCommand( "source-protocol %s%s%s" % ( tunnelTableIdToCliToken(
                       entry.tunnelTableId ), prefString,
                       igpCostPrefString ) )

      if Toggles.TunnelToggleLib.toggleIsisFlexAlgoTunPrefEnabled():
         subProtoPrefString = prefStringDefault
         subProtoIgpCostPrefString = igpCostStringDefault
         for subProtoEntry in sorted( entry.tunRibSubProtoEntries.values() ):
            if subProtoEntry.prefMapping.action == ProtoPrefAction.prefStatic:
               subProtoPrefString = " %s preference %d" % (
                                    subProtoEntry.subProtoName,
                                    subProtoEntry.prefMapping.staticPref )
            if subProtoEntry.igpCostPrefMapping.action == ProtoPrefAction.prefStatic:
               subProtoIgpCostPrefString = " igp-cost preference %d" \
                     % subProtoEntry.igpCostPrefMapping.staticPref
            cmds.addCommand( "source-protocol %s%s%s" % ( tunnelTableIdToCliToken(
                             entry.tunnelTableId ), subProtoPrefString,
                             subProtoIgpCostPrefString ) )

@CliSave.saver( "Tunnel::TunnelTable::TunnelRibConfigDir",
                "tunnel/tunnelRibs/config" )
def saveTunnelRibCliConfig( entity, root, requireMounts, options ):
   trsMode = None
   for tunnelRib in sorted( entity.config.values(),
                            key=lambda config: config.name ):
      if tunnelRib.name in ( "system-tunnel-rib", "system-colored-tunnel-rib" ):
         # We only print the o/p in show running-config
         # if some preference or igp-cost is overridden
         # But we always print the defaults in the show running-config all
         isAnyEntryOverriden = False
         if Toggles.TunnelToggleLib.toggleIsisFlexAlgoTunPrefEnabled():
            for entry in tunnelRib.entry.values():
               if entry.prefMapping.action == ProtoPrefAction.prefStatic or \
                  entry.igpCostPrefMapping.action == ProtoPrefAction.prefStatic or \
                  entry.tunRibSubProtoEntries:
                  isAnyEntryOverriden = True
                  break
         else:
            for entry in tunnelRib.entry.values():
               if entry.prefMapping.action == ProtoPrefAction.prefStatic or \
                     entry.igpCostPrefMapping.action == ProtoPrefAction.prefStatic:
                  isAnyEntryOverriden = True
                  break

         if isAnyEntryOverriden or options.saveAll:
            # At this point either we are printing show running-config and some
            # attribute of the system-tunnel-rib has been overridden, or we
            # are printing the show running-config all
            if not trsMode:
               trsMode = root[ TunnelRibsConfigMode ].getOrCreateModeInstance( None )
            if tunnelRib.name == "system-colored-tunnel-rib":
               saveTunnelRib( tunnelRib, "", "", trsMode, colored=True )
            else:
               saveTunnelRib( tunnelRib, "", "", trsMode )
      elif tunnelRib.name == "system-tunneling-ldp-tunnel-rib":
         # system-tunneling-ldp-tunnel-rib is currently not configurable
         continue
      elif tunnelRib.name == "system-igp-shortcut-tunnel-rib":
         # system-igp-shortcut-tunnel-rib is currently not configurable
         continue
      elif IpLibToggleLib.toggleMplsCbfLdpOverRsvpTeEnabled() and \
           tunnelRib.name == "system-colored-tunneling-ldp-tunnel-rib":
         continue
      elif IpLibToggleLib.toggleMplsCbfSrOverRsvpTeEnabled() and \
            tunnelRib.name == "system-colored-igp-shortcut-tunnel-rib":
         continue
      else:
         # For custom tunnel ribs we print the same o/p in both
         # show running-config and show running-config all
         if not trsMode:
            trsMode = root[ TunnelRibsConfigMode ].getOrCreateModeInstance( None )
         saveTunnelRib( tunnelRib, "", "", trsMode )
