#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode.UplinkFailureDetection import LinkStateMode
import CliSave
from CliSavePlugin.IntfCliSave import IntfConfigMode

class LinkStateConfigMode( LinkStateMode, CliSave.Mode ):

   def __init__( self, param ):
      LinkStateMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( LinkStateConfigMode,
                                       before=[ IntfConfigMode ] )
LinkStateConfigMode.addCommandSequence( 'UplinkFailureDetection.config' )
IntfConfigMode.addCommandSequence( 'UplinkFailureDetection.ethIntf' )

@CliSave.saver( 'UplinkFailureDetection::GroupConfig',
                'interface/errdisable/uplinkFailureDetection/config',
                attrName='group' )
def saveUplinkFailureDetectionConfig( groupConfig, root, requireMounts, options ):
   groupName = groupConfig.name
   mode = root[ LinkStateConfigMode ].getOrCreateModeInstance( groupName )
   cmds = mode[ 'UplinkFailureDetection.config' ]
   if options.saveAll or groupConfig.minLinks != groupConfig.minLinksDefault:
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( "links minimum %d" % groupConfig.minLinks )
   if options.saveAll or ( groupConfig.recoveryDelay !=
                           groupConfig.recoveryDelayDefault ):
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( "recovery delay %d" % groupConfig.recoveryDelay )
   for uplink in groupConfig.intfsToMonitor:
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( uplink )
      ethIntfCmds = mode[ 'UplinkFailureDetection.ethIntf' ]
      # pylint: disable-next=consider-using-f-string
      ethIntfCmds.addCommand( "link tracking group %s upstream" % groupName )
   for downlink in groupConfig.intfsToDisable:
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( downlink )
      ethIntfCmds = mode[ 'UplinkFailureDetection.ethIntf' ]
      # pylint: disable-next=consider-using-f-string
      ethIntfCmds.addCommand( "link tracking group %s downstream" % groupName )
