# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode.Upnp import UpnpMode
import CliSave
import Tac

class UpnpCliSaveMode( UpnpMode, CliSave.Mode ):
   def __init__( self, param ):
      UpnpMode.__init__( self )
      CliSave.Mode.__init__( self, param )

UpnpCliSaveMode.addCommandSequence( 'Upnp.global' )
CliSave.GlobalConfigMode.addChildMode( UpnpCliSaveMode )

@CliSave.saver( 'Upnp::Config', 'upnp/config' )
def saveUpnpConfig( entity, root, requireMounts, options ):
   saveAllDetail = options.saveAllDetail

   # UPNP global commands
   upnpMode = root[ UpnpCliSaveMode ].getOrCreateModeInstance( param=None )
   upnpCmds = upnpMode[ 'Upnp.global' ]
   if entity.uuid != Tac.Value( "Arnet::Uuid" ):
      upnpCmds.addCommand( "uuid " + entity.uuid.stringValue )
   elif saveAllDetail:
      upnpCmds.addCommand( "no uuid" )
