#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.RouterGeneralCliSave import RouterGeneralCliSaveMode
import Tac
from CliMode.UrpfMode import ( UrpfLooseModeBase, UrpfStrictModeBase )

class UrpfLooseMode( UrpfLooseModeBase, CliSave.Mode ):
   def __init__( self, param ):
      UrpfLooseModeBase.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

RouterGeneralCliSaveMode.addChildMode( UrpfLooseMode )
UrpfLooseMode.addCommandSequence( 'UrpfLooseMode.config' )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config' )
def saveUrpfLooseModeForceForward( entity, root, requireMounts, options ):
   generalMode = root[ RouterGeneralCliSaveMode ].getSingletonInstance()
   mode = generalMode[ UrpfLooseMode ].getSingletonInstance()
   cmds = mode[ 'UrpfLooseMode.config' ]
   if entity.looseUrpfFailForceFwd:
      cmds.addCommand( 'ipv4 ipv6 failure action forward' )
   elif options.saveAll:
      cmds.addCommand( 'no ipv4 ipv6 failure action forward' )

class UrpfStrictMode( UrpfStrictModeBase, CliSave.Mode ):
   def __init__( self, param ):
      UrpfStrictModeBase.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

RouterGeneralCliSaveMode.addChildMode( UrpfStrictMode )
UrpfStrictMode.addCommandSequence( 'UrpfStrictMode.config' )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config' )
def saveUrpfStrictModeForceForward( entity, root, requireMounts, options ):
   generalMode = root[ RouterGeneralCliSaveMode ].getSingletonInstance()
   mode = generalMode[ UrpfStrictMode ].getSingletonInstance()
   cmds = mode[ 'UrpfStrictMode.config' ]
   if entity.strictUrpfFailForceFwd:
      cmds.addCommand( 'ipv4 ipv6 failure action forward' )
   elif options.saveAll:
      cmds.addCommand( 'no ipv4 ipv6 failure action forward' )
