#!/usr/bin/env python3
# Copyright (c) 2010-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import re
import CliSave
import Url
from CliSavePlugin.IntfCliSave import IntfConfigMode
from CliMode.Vm import VmMode

#-------------------------------------------------------------
# Object used for saving commands in "config-vm" mode
#-------------------------------------------------------------
class VmConfigMode( VmMode, CliSave.Mode ):

   def __init__( self, param ):
      VmMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( VmConfigMode, after=[ IntfConfigMode ] )
VmConfigMode.addCommandSequence( 'Vm.config' )

@CliSave.saver( 'Vm::VmConfig', 'vm/config' )
def saveVmConfig( entity, root, requireMounts, options ):
   mode = root[ VmConfigMode ].getOrCreateModeInstance( entity.name )
   cmds = mode[ 'Vm.config' ]
   if entity.configFile != "":
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'config-file %s' % Url.filenameToUrl( entity.configFile ) )
   else:
      if entity.diskImage != "":
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'disk-image %s' % 
                Url.filenameToUrl( entity.diskImage ) )

      if entity.memorySize:
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'memory-size %d' % entity.memorySize )

      for vnicName in sorted( entity.vnicConfig ):
         vnic = entity.vnicConfig[ vnicName ]
         if vnic:
            m = re.match( r'vnic(\d+)', vnicName )
            if m:
               vnicId = int( m.group( 1 ) )
               # pylint: disable-next=consider-using-f-string
               cmds.addCommand( 'virtual-nic %d %s %s' % 
                                ( vnicId,
                                  vnic.backendDev,
                                  vnic.macAddr) )
      if entity.vncPort:
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'vnc-port %d' % entity.vncPort )

   if entity.enabled:
      cmds.addCommand( 'enable' )
