#!/usr/bin/env python3
# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliSavePlugin import IntfCliSave
import CliSave 
IntfCliSave.IntfConfigMode.addCommandSequence( 'VmTracer.config' )

@CliSave.saver( 'Cdp::CdpConfig', 'l2discovery/cdp/config' )
def saveVmTracerIntfConfig( entity, root, requireMounts, options ):

   # Save interface specific settings
   for intfName in entity.intfNames:
      mode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance( intfName )
      intfCmds = mode[ 'VmTracer.config' ]
      intfCmds.addCommand( 'vmtracer vmware-esx' )
   for lagName in entity.lagNames:
      mode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance( lagName )
      intfCmds = mode[ 'VmTracer.config' ]
      intfCmds.addCommand( 'vmtracer vmware-esx' )
