# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliSave
from CliSavePlugin.IntfCliSave import IntfConfigMode

IntfConfigMode.addCommandSequence( 'VxlanIntf.igmpSnooping' )

@CliSave.saver( "Bridging::Gmp::VxlanGmpSnoopingConfig",
                "bridging/igmpsnooping/vxlan/config",
                requireMounts=( "bridging/hwcapabilities",
                                "interface/config/eth/vxlan" ) )
def saveVxlanIgmpSnooping( config, root, requireMounts, options ):
   hwCapability = requireMounts[ 'bridging/hwcapabilities' ]

   if ( not hwCapability.vxlanSupported
        or not hwCapability.vxlanMcastUnderlayHerSupported ):
      return
   vtiConfigDir = requireMounts[ 'interface/config/eth/vxlan' ]
   for vti in vtiConfigDir.vtiConfig:
      snoopingVtiConfig = config.vtiConfig.get( vti )
      if snoopingVtiConfig and snoopingVtiConfig.snoopingEnabled:
         cmd = "igmp snooping"
      elif options.saveAll:
         cmd = "no igmp snooping"
      else:
         cmd = None
      if cmd:
         mode = root[ IntfConfigMode ].getOrCreateModeInstance( vti )
         cmds = mode[ 'VxlanIntf.igmpSnooping' ]
         cmds.addCommand( cmd )
