# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.IntfCliSave import IntfConfigMode
from MultiRangeRule import multiRangeToCanonicalString
from TypeFuture import TacLazyType

Polarity = TacLazyType( 'Hardware::L1Topology::Polarity' )

qualifiedPolarityOutput = {
   "configDefault": "default",
   Polarity.polarityDefault: "standard",
   Polarity.polaritySwap: "reversed",
}

IntfConfigMode.addCommandSequence( 'Xcvr.polarity' )

@CliSave.saver( 'Hardware::L1Topology::PolarityOverrideDir',
                'intfSlot/config/polarity/override' )
def saveXcvrPolarityConfig( polarityOverrideDir, root, requireMounts, options ):
   for spo in polarityOverrideDir.slotPolarityOverride.values():

      # TODO BUG1000059 - When we move to port level config, the primaryIntfId
      # attribute will be removed, so we'll need to look up the port config using
      # the intfSlotDesc instead.
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( spo.primaryIntfId )
      cmds = mode[ 'Xcvr.polarity' ]

      polarityData = { "transmitter": {}, "receiver": {} }
      for laneId, over in spo.txLaneOverride.items():
         command = qualifiedPolarityOutput[ over.polarity ]
         polarityData[ "transmitter" ].setdefault( command, [] ).append( laneId )
      for laneId, over in spo.rxLaneOverride.items():
         command = qualifiedPolarityOutput[ over.polarity ]
         polarityData[ "receiver" ].setdefault( command, [] ).append( laneId )

      for direction, laneData in polarityData.items():
         for command, lanes in laneData.items():
            laneStr = multiRangeToCanonicalString( lanes )
            cmds.addCommand(
               f'phy { direction } polarity lanes { laneStr } { command }' )
