# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import TerminalUtil
import os.path

warningFilepath = '/etc/login-message.console'

# For privacy reasons, notify the user if the output sent to the
# serial console is being recorded. This will only be done when
# the user logs in to the serial console and only if the warning
# file exists.
def printWarningMessage():
   if not TerminalUtil.isConsole():
      return
   if not os.path.isfile( warningFilepath ):
      return

   try:
      with open( warningFilepath ) as f:
         print( f.read() )
   except OSError:
      # One possible IO error is in the case of a race condition
      # where the file was removed after testing for it and before
      # printing it. Another is the case of a permission issue.
      pass
   except: # pylint: disable=bare-except
      assert not "Unexpected error when reading warning file"

def Plugin( context ):
   printWarningMessage()

