# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMatcher import IntegerMatcher, KeywordMatcher

# Integer matchers
matcherDangerousStatsInt = IntegerMatcher( 1, 9,
      helpdesc='Session statistics timer interval in seconds between 1-9' )

matcherDebugLevel = IntegerMatcher( 0, 3,
      helpdesc=( 'Logging level number: '
                 '0(none) 1(Errors) 2(Debug)'
                 '3(Packet Firehose)' ) )

matcherDiscriminator = IntegerMatcher( 1, 2**32 - 1,
      helpdesc='BFD session discriminator to debug' )

matcherMultiplierVal = IntegerMatcher( 3, 50, helpdesc='Multiplier value' )

matcherOuterDstPort = IntegerMatcher( 1024, 65535,
      helpdesc='Outer destination port' )

matcherOuterSrcPort = IntegerMatcher( 1024, 65535, helpdesc='Outer source port' )

matcherStatsInt = IntegerMatcher( 10, 3600,
      helpdesc='Session statistics timer interval in seconds between 10-3600' )

matcherSlowTimer = IntegerMatcher( 2000, 60000, helpdesc='Rate in milliseconds' )

matcherTxRxIntervalMs = IntegerMatcher( 50, 60000, helpdesc='Rate in milliseconds' )

matcherVNI = IntegerMatcher( 0, 16777216,
      helpdesc='VNI used to send the BFD packet' )

# Keyword matchers
matcherAccessGroup = KeywordMatcher( 'access-group',
      helpdesc='Configure access control list' )

matcherBfd = KeywordMatcher( 'bfd',
      helpdesc='Configure BFD specific configurations' )

matcherBfdForClear = KeywordMatcher( 'bfd',
      helpdesc='Clear BFD counters and statistics' )

matcherDangerous = KeywordMatcher( 'dangerous',
      helpdesc='DANGEROUS: Set session statistics timer interval '
               'less than 10 seconds' )

matcherDebug = KeywordMatcher( 'debug',
      helpdesc='Debug logging level for the rbfd module' )

matcherEthernet = KeywordMatcher( 'Ethernet', helpdesc='Ethernet Sub Interface' )

matcherIn = KeywordMatcher( 'in', helpdesc='Inbound packets' )

matcherInitiator = KeywordMatcher( 'initiator',
      helpdesc='Configure the active node in an SBFD session' )

matcherInterval = KeywordMatcher( 'interval',
      helpdesc='Set transmit rate in milliseconds' )

matcherLoopback = KeywordMatcher( 'Loopback',
      helpdesc='Hardware interface used for looping packets' )

matcherMeticulous = KeywordMatcher( 'meticulous', helpdesc='Meticulous mode' )

matcherMinRxDeprecated = KeywordMatcher( 'min_rx',
      helpdesc='Set expected minimum incoming rate in milliseconds' )

deprecatedData = {
      'bfd': matcherBfd,
      'min_rx': matcherMinRxDeprecated,
}

matcherMinRx = KeywordMatcher( 'min-rx',
      helpdesc='Set expected minimum incoming rate in milliseconds' )

matcherMultihop = KeywordMatcher( 'multihop', helpdesc='Multihop BFD session' )

matcherMultiplier = KeywordMatcher( 'multiplier',
      helpdesc='Sets the BFD multiplier' )

matcherSession = KeywordMatcher( 'session', helpdesc='BFD session settings' )

matcherVlan = KeywordMatcher( 'Vlan', helpdesc='Logical interface into a VLAN' )

matcherVrf = KeywordMatcher( 'vrf',
      helpdesc='Configure the VRF in which to apply the access control list' )
