# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliCommand import CliExpression
from CliMatcher import (
   EnumMatcher,
   KeywordMatcher,
)

tokenLinkState = KeywordMatcher( "link-state", "Link-state information" )

nlriTypeMatcher = EnumMatcher( {
   'node': 'Link-state node information',
   'link': 'Link-state link information',
   'ipv4-prefix': 'Link-state IPv4 prefix information',
   'ipv6-prefix': 'Link-state IPv6 preifx information',
} )

class BgpLsNlriType( CliExpression ):
   expression = "NLRI_TYPE"
   data = {
      "NLRI_TYPE": nlriTypeMatcher,
   }

   @staticmethod
   def adapter( mode, args, argList ):
      cliToEnumStr = {
         'node': 'linkStateNode',
         'link': 'linkStateLink',
         'ipv4-prefix': 'linkStateIpv4Prefix',
         'ipv6-prefix': 'linkStateIpv6Prefix',
      }
      args[ 'NLRI_TYPE' ] = cliToEnumStr.get( args.pop( 'NLRI_TYPE', None ) )
