#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMatcher

# This contains tokens for 'logging event'.
# Certain keywords are used by LogMgr as well.

# Global config keywords

loggingForConfig = CliMatcher.KeywordMatcher(
   'logging', helpdesc="Configure logging" )

eventForConfig = CliMatcher.KeywordMatcher(
   'event', helpdesc='Configure logging events' )

# Interface config keywords
loggingForConfigIf = CliMatcher.KeywordMatcher(
   'logging', helpdesc='Interface-related logging configuration' )

eventForConfigIf = CliMatcher.KeywordMatcher(
   'event', helpdesc='Interface-related logging configuration' )

useGlobalForConfigIf = CliMatcher.KeywordMatcher(
   'use-global', helpdesc='Use the global configuration' )

# This 'testfile' attribute is used by Eos/test/EosCliTokenTest.py to
# load tests to run as part of autobuild of the Eos package. It should
# also run as a standalone product test.
testfile = 'Intf/CliTokenTest.py'

