# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMatcher import KeywordMatcher, EnumMatcher

multicastMatcherForShow = KeywordMatcher( 'multicast',
                                          helpdesc='Multicast information' )
sourceMatcher = KeywordMatcher( 'source', helpdesc='Source of (S,G) traffic' )

ipv4HelpDesc = 'Display IPv4 information'
ipv4ForShow = KeywordMatcher( 'ipv4', helpdesc=ipv4HelpDesc )

ipv6HelpDesc = 'Display IPv6 information'
ipv6ForShow = KeywordMatcher( 'ipv6', helpdesc=ipv6HelpDesc )

afMatcherForShow = EnumMatcher( {
   'ipv4': ipv4HelpDesc,
   'ipv6': ipv6HelpDesc
} )

ipv4ForClear = KeywordMatcher( 'ipv4', helpdesc='Clear IPv4 information' )
ipv6ForClear = KeywordMatcher( 'ipv6', helpdesc='Clear IPv6 information' )
rpfKwMatcher = KeywordMatcher( 'rpf', helpdesc='RPF config commands' )
