# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliCommand import hiddenKeyword
from CliMatcher import (
      KeywordMatcher,
      PatternMatcher,
   )
from CliToken import Router
from Url import UrlMatcher
from CliPlugin.RcfCliLib import rcfFunctionPattern

#----------------------------------------------------------------------------------
#                                K E Y W O R D S
#----------------------------------------------------------------------------------

# Keyword matchers: please keep these alphabetically sorted
afterKw = KeywordMatcher( 'after',
   helpdesc="Insert after labeled block" )
allKw = KeywordMatcher( 'all',
   helpdesc="All RCF code units" )
beforeKw = KeywordMatcher( 'before',
   helpdesc="Insert before labeled block" )
blockKw = KeywordMatcher( 'block',
   helpdesc="Unconditional RCF text block" )
codeKw = KeywordMatcher( 'code',
   helpdesc="Routing control function code" )
committedCodeKw = KeywordMatcher( 'code',
   helpdesc="Committed routing control function code" )
commitKw = KeywordMatcher( 'commit',
   helpdesc="Commit pending routing control function code" )
compileKw = KeywordMatcher( 'compile',
   helpdesc="Compile pending routing control function code" )
controlFunctionsKwForConfig = KeywordMatcher( 'control-functions',
   helpdesc="Routing control functions configuration" )
deleteKw = KeywordMatcher( 'delete',
   helpdesc="Delete routing control function code" )
diffKw = KeywordMatcher( 'diff',
   helpdesc="Difference between pending and committed "
            "routing control function code" )
discardKw = KeywordMatcher( 'discard',
   helpdesc="Discard pending routing control function code" )
editKw = KeywordMatcher( 'edit',
   helpdesc="Edit routing control functions code in an editor" )
editedKw = KeywordMatcher( 'edited',
   helpdesc="Routing control function code was edited since the last pull" )
errorsKw = KeywordMatcher( 'errors',
   helpdesc="Compilation errors" )
functionKw = KeywordMatcher( 'function',
   helpdesc="RCF function" )
functionFilterKw = KeywordMatcher( 'function',
   helpdesc="Filter by RCF function" )
insertKw = KeywordMatcher( 'insert',
   helpdesc="Insert routing control function code" )
locationFunctionKw = KeywordMatcher( 'location',
   helpdesc="Show location of function names" )
openConfigKw = KeywordMatcher( 'openconfig', helpdesc='OpenConfig format' )
pendingKw = KeywordMatcher( 'pending',
   helpdesc="Pending routing control function code" )
pulledFromKw = KeywordMatcher( 'pulled-from',
   helpdesc="Source file URL of last pull" )
pullKw = KeywordMatcher( 'pull',
   helpdesc="Pull routing control function code" )
pushKw = KeywordMatcher( 'push',
      helpdesc="Push routing control function code" )
replaceKw = KeywordMatcher( 'replace',
   helpdesc="Replace routing control function code" )
routerKw = Router.routerMatcherForConfig
runningConfigKw = KeywordMatcher( 'running-config',
   helpdesc="Routing control function code from running-config" )
sourceKw = KeywordMatcher( 'source',
   helpdesc="Routing control function code unit source information" )
startupKw = hiddenKeyword( 'startup' )
unitKw = KeywordMatcher( 'unit',
   helpdesc="Routing control function code unit" )
unitFilterKw = KeywordMatcher( 'unit',
   helpdesc="Filter by RCF code unit" )

# Pattern matchers: please keep these alphabetically sorted

# funcNameMatcher mirrors the funcName rule in Rcf/Rcf.g4
funcNameMatcher = PatternMatcher(
        pattern=rcfFunctionPattern,
        helpdesc="RCF function name",
        helpname='FUNCNAME' )
# labelMatcher mirrors the LABEL rule in Rcf/RcfCommonLexerRules.g4
# pylint: disable-msg=anomalous-backslash-in-string
labelMatcher = PatternMatcher( pattern='@([A-Za-z0-9_])([A-Za-z0-9_:\\\\[\\]=+-.]*)',
                               helpdesc="RCF label name",
                               helpname='@LABEL' )

# URL matchers: please keep these alphabetically sorted
urlMatcherPush = UrlMatcher( lambda fs: fs.supportsWrite(),
                             'Destination file URL',
                             allowAllPaths=True )
urlMatcherSource = UrlMatcher( lambda fs: fs.supportsRead(),
                               'Source file URL',
                               allowAllPaths=True )

# String
unnamedCodeUnitString = "unnamed code unit"
