# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Tac
import Tracing

t0 = Tracing.trace0

class DmfConfigFilterReactor( Tac.Notifiee ):
   notifierTypeName = "Dmf::Cli::Config"

   def __init__( self, notifier, em ):
      Tac.Notifiee.__init__( self, notifier )
      self.em_ = em
      self.handleEnabled()

   @Tac.handler( 'enabled' )
   def handleEnabled( self ):
      t0( "DmfConfigFilterReactor.handleEnabled()", self.notifier_.enabled )
      if self.notifier_.enabled:
         CliSession.activeConfigRootFilterIs( self.em_, 'DMF' )
      else:
         CliSession.activeConfigRootFilterIs( self.em_, None )

class DmfConfigAgentPluginStarter:
   def __init__( self, em, mg, agent ):
      self.em_ = em
      self.agent_ = agent
      self.dmfConfig_ = None
      self.dmfConfigFilterReactor_ = None
      self.doMounts( mg )

   def doMounts( self, mg ):
      self.dmfConfig_ = mg.mount( 'dmf/cli/config',
                                  'Dmf::Cli::Config', 'ri' )

   def run( self ):
      t0( "running DmfConfigFilterReactor" )
      self.dmfConfigFilterReactor_ = DmfConfigFilterReactor( self.dmfConfig_,
                                                             self.em_ )

def Plugin( context ):
   t0( "register DmfConfigAgentPluginStarter" )
   context.registerStateMachine( DmfConfigAgentPluginStarter )
