# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AirStreamLib
import Tac
import Tracing

th = Tracing.Handle( "RouterAdvtConfigSession" )
t0 = th.trace0

class ToExternalIpv6RouterAdvtSmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   nativePathAndType = [ ( 'routing6/routerAdvt/config', 'RouterAdvt::Config' ) ]
   externalPathAndType = [
      ( 'routing6/routerAdvt/openconfig/config/subIntfConfig',
        'RouterAdvt::OpenConfig::OcRouterAdvtSubInterfaceConfig' ),
      ( 'routing6/routerAdvt/openconfig/config/routedVlanConfig',
        'RouterAdvt::OpenConfig::OcRouterAdvtRoutedVlanConfig' ),
   ]
   smType = 'RouterAdvt::OpenConfig::OcRouterAdvtConfigSm'

   def createSm( self ):
      t0( 'Create OcRouterAdvtConfigSm' )
      self.toExternalSm = Tac.newInstance( self.smType, self.nativeEntity(),
                                           self.externalEntity(),
                                           self.externalEntity( 1 ) )

def Plugin( context ):
   context.registerStateMachine( ToExternalIpv6RouterAdvtSmWrapper )
