# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Tac
import Tracing
import AirStreamLib

t5 = Tracing.Handle( "L1OpenConfigAgent" ).trace5

class ToExternalXcvrSmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   '''
   This plugin starts the state machine which is one part of the system which manages
   changes in transceiver attributes which are configured both by the CLI and by
   OpenConfig.  This state machine reacts to changes made by the CLI to transceiver
   attributes and copies those changes to the corresponding OpenConfig attributes.
   The other direction - copying changes in the OpenConfig attributes to the
   transceiver entities - is handled by a ConfigSessionPlugin.
   '''
   # The nativePath is the path to the native entity
   # The smType is the unique string representation of the actual sm
   # These are used to register the sm to StatefulSmManager
   nativePathAndType = [ ( 'hardware/xcvr/xgc', 'Xcvr::Xgc' ),
                         ( 'hardware/xcvr/cli/config/slice', 'Tac::Dir' ),
                         ( 'hardware/xcvr/config/all', 'Xcvr::AllConfigDir' ),
                         ( 'hardware/l1/openConfig/xcvr/logicalChannelAssignment',
                           'L1OpenConfig::Xcvr::LogicalChannelAssignment' ),
                         ( 'hardware/l1/openConfig/xcvr/logicalChannelIngress',
                           'L1OpenConfig::Xcvr::LogicalChannelIngressState' ) ]
   externalPathAndType = [
      ( 'hardware/l1/openConfig/xcvrConfig/opticalChannel',
        'L1OpenConfig::Xcvr::OpticalChannelConfigBase' ),
      ( 'hardware/l1/openConfig/xcvrConfig/logicalChannel',
        'L1OpenConfig::Xcvr::LogicalChannelConfig' ),
      ( 'hardware/l1/openConfig/xcvrConfig/physicalChannel',
        'L1OpenConfig::Xcvr::PhysicalChannelConfigBase' ),
      ( 'hardware/l1/openConfig/xcvrConfig/transceiver',
        'L1OpenConfig::Xcvr::TransceiverConfigBase' ) ]
   smType = 'L1OpenConfig::Xcvr::ToExternalXcvrConfigSm'

   def createSm( self ):
      t5( 'create ToExternalXcvrConfigSm' )
      self.toExternalSm = Tac.newInstance( self.smType, self.nativeEntity( 0 ),
                                           self.externalEntity( 0 ),
                                           self.externalEntity( 1 ),
                                           self.externalEntity( 2 ),
                                           self.nativeEntity( 1 ),
                                           self.externalEntity( 3 ),
                                           self.nativeEntity( 2 ),
                                           self.nativeEntity( 3 ),
                                           self.nativeEntity( 4 ) )

def Plugin( context ):
   context.registerStateMachine( ToExternalXcvrSmWrapper )
