# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AirStreamLib
import Tac
from Toggles.LoopProtectToggleLib import toggleLoopProtectOpenConfigEnabled

class ToExternalConfigSmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   nativePathAndType = [
      ( "loopprotect/config", "LoopProtect::Config::Config" ),
      ( "loopprotect/status", "LoopProtect::Status::Status" ),
      ( "bridging/config", "Bridging::Config" ),
   ]
   externalPathAndType = [
      ( "loopprotect/openconfig/config", "LoopProtect::OpenConfig::Config" ),
      ( "loopprotect/openconfig/state", "LoopProtect::OpenConfig::State" ),
   ]
   smType = "LoopProtect::ToExternalConfigSm"

   def createSm( self ):
      self.toExternalSm = Tac.newInstance( self.smType,
                                           self.nativeEntity(),
                                           self.nativeEntity( 1 ),
                                           self.nativeEntity( 2 ),
                                           self.externalEntity(),
                                           self.externalEntity( 1 ) )

def Plugin( context ):
   if toggleLoopProtectOpenConfigEnabled():
      context.registerStateMachine( ToExternalConfigSmWrapper )
