# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
import AirStreamLib

t0 = Tracing.Handle( "OspfOpenConfig" ).trace0

class ToExternalOspfInstanceSmWrapper( AirStreamLib.ToExternalSmWrapperBase ):
   # The nativePath is the path to the native entity
   # The smType is the unique string representation of the actual sm
   # These are used to register the sm to StatefulSmManager
   nativePathAndType = [ ( 'routing/ospf/config', 'Routing::Ospf::Config' ),
         ( 'ip/status', 'Ip::Status' ) ]
   externalPathAndType = [
         ( 'routing/ospf/openconfig/instances',
            'Routing::Ospf::OCOspfInstanceDir' ) ]
   smType = 'Routing::Ospf::ToExternalOspfInstanceSm'

   def createSm( self ):
      t0( 'create ToExternalOspfInstanceSmWrapper' )
      self.toExternalSm = Tac.newInstance( self.smType,
                                           self.nativeEntity(),
                                           self.nativeEntity( 1 ),
                                           self.externalEntity() )

def Plugin( context ):
   context.registerStateMachine( ToExternalOspfInstanceSmWrapper )
