# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''
Registers SM translating RouteMap EOS/CLI configuration to OpenConfig
'''

from Toggles.OpenConfigRoutingPolicyToggleLib import (
   toggleAirStreamPolicyDefinitionsEnabled,
)

import AirStreamLib
import Tac
import Tracing

th = Tracing.Handle( 'RoutingPolicyOpenConfig' )
t0 = th.trace0

TACC_NAMESPACE = 'Routing::Policy::OpenConfig'

class RoutingPolicyOpenConfigToExternalSmWrapper(
      AirStreamLib.ToExternalSmWrapperBase ):
   nativePathAndType = [ ( 'routing/routemap/config', 'Routing::RouteMap::Config' ) ]
   externalPathAndType = [ ( 'routing/policy/openconfig/policyDefinitions',
                             f'{TACC_NAMESPACE}::PolicyDefinitions' ) ]
   smType = f'{TACC_NAMESPACE}::ToExternalSm'

   # override from parent
   def createSm( self ):
      # Store SM in the instance to protect it from being garbage collected.
      self.toExternalSm = Tac.newInstance( self.smType,
                                           self.nativeEntity(),
                                           self.externalEntity() )
      t0( 'To-external SM created' )

def Plugin( context ):
   if not toggleAirStreamPolicyDefinitionsEnabled():
      return

   context.registerStateMachine( RoutingPolicyOpenConfigToExternalSmWrapper )
   t0( 'RoutingPolicyOpenConfigToExternal plugin installed' )
