# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
import Toggles.XcvrToggleLib
import Cell

t5 = Tracing.Handle( "XcvrCentralAgent" ).trace5

class XcvrCentralAgentRunnabilitySm():
   '''
   This state machine is in charge of writing to the config of XcvrCentralAgent
   The agentRunnable should be True when the Launcher is expected to start
   XcvrCentralAgent (which only happens on modular systems), and False when the
   XcvrAgent should spawn a local XcvrCentralAgent.
   '''
   def __init__( self, em, mg, agent ):
      self.em = em
      self.agent = getattr( agent, 'agent_', agent )
      self.xcvrCentralConfig = None
      self.doMounts( mg )

   def doMounts( self, mg ):
      self.xcvrCentralConfig = mg.mount( 'hardware/xcvr/central/config',
                                         'XcvrCentralAgent::XcvrCentralConfig',
                                         'w' )

   def run( self ):
      isModular = Cell.cellType() == 'supervisor'
      self.xcvrCentralConfig.agentRunnable = \
         isModular and Toggles.XcvrToggleLib.toggleXcvrCentralAgentEnabled()

def Plugin( context ):
   context.registerStateMachine( XcvrCentralAgentRunnabilitySm )
