# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   cfg = entMan.lookup( 'acl/config/cli' )
   cpCfg = entMan.lookup( 'acl/cpconfig/cli' )
   paramCfg = entMan.lookup( 'acl/paramconfig' )
   # EntityCopy handler for AclConfig
   aclHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                                "Acl",
                                                "Acl::AclConfigCopyHandlerDir" )
   aclHandlerDir.copyHandler = ()
   aclHandler = aclHandlerDir.copyHandler
   aclHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         "",
                                         "Acl::Input::AclTypeConfig",
                                         aclHandler )
   for t in ( "set", "del" ):
      CliSession.registerAttributeEditLogBypass( entMan,
                                                 cfg.fullName,
                                                 "", "",
                                                 t,
                                                 None )
      CliSession.registerAttributeEditLogBypass( entMan,
                                                 cpCfg.fullName,
                                                 "", "",
                                                 t,
                                                 None )
      CliSession.registerAttributeEditLogBypass( entMan,
                                                 paramCfg.fullName,
                                                 "", "",
                                                 t,
                                                 None )

   # EntityCopy handler for AclIntfConfig
   aclIntfHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                                "AclIntf",
                                                "Acl::AclIntfConfigCopyHandlerDir" )
   aclIntfHandlerDir.copyHandler = ( cfg, )
   aclIntfHandler = aclIntfHandlerDir.copyHandler
   CliSession.registerCustomCopyHandler( entMan,
                                         "",
                                         "Acl::IntfTypeConfig",
                                         aclIntfHandler )
