# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliSession

def Plugin( entMan ):
   config = entMan.lookup( 'routing/bgp/config' )
   vrfConfig = entMan.lookup( 'routing/bgp/vrf/config' )

   for af in [ '', 'IPv4Uni', 'IPv6Uni', 'Evpn' ]:
      attr = 'maxRoutesConfig%s' % af # pylint: disable=consider-using-f-string
      CliSession.registerAttributeEditLogBypass( entMan, config.fullName,
         attr, "Routing::Bgp::MaxRoutesConfig", "set" )
      CliSession.registerAttributeEditLogBypass( entMan, vrfConfig.fullName,
         attr, "Routing::Bgp::MaxRoutesConfig", "set" )
      CliSession.registerAttributeEditLogBypass( entMan, config.fullName,
         attr + 'Present', "bool", "set" )
      CliSession.registerAttributeEditLogBypass( entMan, vrfConfig.fullName,
         attr + 'Present', "bool", "set" )
      # pylint: disable-next=consider-using-f-string
      attr = 'maxAcceptedRoutesConfig%s' % af
      CliSession.registerAttributeEditLogBypass( entMan, config.fullName,
         attr, "Routing::Bgp::MaxAcceptedRoutesConfig", "set" )
      CliSession.registerAttributeEditLogBypass( entMan, vrfConfig.fullName,
         attr, "Routing::Bgp::MaxAcceptedRoutesConfig", "set" )
      CliSession.registerAttributeEditLogBypass( entMan, config.fullName,
         attr + 'Present', "bool", "set" )
      CliSession.registerAttributeEditLogBypass( entMan, vrfConfig.fullName,
         attr + 'Present', "bool", "set" )

   # -------------------------------------------------------------------------
   # Custom entity copy handlers
   # -------------------------------------------------------------------------
   listenRangeHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                                              "ListenRange",
                           "Routing::Bgp::ListenRangeCopyHandlerDir" )
   listenRangeHandlerDir.copyHandler = ()
   listenRangeHandler = listenRangeHandlerDir.copyHandler
   listenRangeHandler.initialize()

   CliSession.registerCustomCopyHandler( entMan, "", "Routing::Bgp::Config",
                                         listenRangeHandler )
