# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   CliSession.registerEntityCopyFilter(
      entMan, "", "VrfSelectionPolicy::VrfSelectionPolicyConfig", [],
      orderedAttrsBefore=[ "actions" ] )

   # Custom Copy handler for Config
   tpCopyHandlerDir = CliSession.registerCopyHandlerDir( entMan,
         "VrfSelectionPolicyConfig", "TrafficPolicy::TrafficPolicyCopyHandlerDir" )
   tpCopyHandlerDir.tpCopyHandler = ()
   tpCopyHandlerDir.tpCopyHandler.initialize()
   CliSession.registerCustomCopyHandler(
      entMan, "", "VrfSelectionPolicy::VrfSelectionPolicyConfig",
      tpCopyHandlerDir.tpCopyHandler )
