# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   cli = entMan.lookup( "bridging/input/config/cli" )

   # pylint: disable-next=import-outside-toplevel
   import ConfigSessionPlugin.Intf         # pylint: disable-msg=F0401
   ConfigSessionPlugin.Intf.registerIntfEntityFilters(
      entMan, "interface/config/eth/vlan", "Interface::VlanIntfConfig" )

   attrEditBypassParentDir = CliSession.attributeEditBypassDir( entMan )
   fdbConfigDefault = None
   switchIntfConfigDefault = None
   if attrEditBypassParentDir:
      dummyEbraConfig = attrEditBypassParentDir.newEntity(
         "Bridging::Input::Config", "DummyEbraConfig" )
      fdbConfigDefault = dummyEbraConfig.fdbConfig.newMember( 4094 )
      switchIntfConfigDefault = dummyEbraConfig.switchIntfConfig.newMember( "",
                                                                          "access" )

   CliSession.registerAttributeEditLogBypass( entMan, cli.fullName, "fdbConfig",
                                              "Bridging::Input::FdbConfig", "del",
                                              fdbConfigDefault )

   CliSession.registerAttributeEditLogBypass( entMan, cli.fullName,
                                              "switchIntfConfig",
                                              "Bridging::Input::SwitchIntfConfig",
                                              "del", switchIntfConfigDefault )

   # The Bridging::Input::SwitchIntfConfig.ingressVlanXlate and .egressVlanXlate
   # maps, and the ingressNativeVlanXlate and egressNativeVlanXlate attributes
   # are in some cases deleted when running the config-replace debug-attribute
   # test. This is correct behavior (see BUG87356). Register edit log bypass',
   # allowing deletes of any mapping or clearing of the native translations. 
   CliSession.registerAttributeEditLogBypass( entMan, cli.fullName,
                                              "ingressVlanXlate",
                                              "Bridging::VlanId",
                                              "del", None )
   CliSession.registerAttributeEditLogBypass( entMan, cli.fullName,
                                              "egressVlanXlate",
                                              "Bridging::VlanId",
                                              "del", None )
   CliSession.registerAttributeEditLogBypass( entMan, cli.fullName,
                                              "ingressNativeVlanXlate",
                                              "Bridging::VlanIdOrNone",
                                              "set", None )
   CliSession.registerAttributeEditLogBypass( entMan, cli.fullName,
                                              "egressNativeVlanXlate",
                                              "Bridging::VlanIdOrNone",
                                              "set", None )

   # Bridging::Input::SwitchIntfConfig.privateVlanMapping and
   # defaultPrivateVlanMapping are in some cases deleted/set when running
   # the config-replace debug-attribute test. Register edit log bypass'
   # allowing delete of privateVlanMapping or set of defaultPrivateVlanMapping
   CliSession.registerAttributeEditLogBypass( entMan, cli.fullName,
                                              "privateVlanMapping",
                                              "bool",
                                              "del", None )
   CliSession.registerAttributeEditLogBypass( entMan, cli.fullName,
                                              "defaultPrivateVlanMapping",
                                              "bool",
                                              "set", None )

   # Bridging::Input::SwitchIntfConfig gets created during config
   # replace with "switchport default mode routed" due to
   # "no switchport" saved under the interface. The attribute enabled gets
   # set too. This is not entirely correct but a side effect of allowing CliPlugin
   # to create switchIntfConfig in cliConfig when we explicitly run "no switchport"
   # under interfaces with global "switchport default mode routed" configured
   CliSession.registerAttributeEditLogBypass( entMan, cli.fullName,
                                              "switchIntfConfig",
                                              "Bridging::Input::SwitchIntfConfig",
                                              "set", None )

   CliSession.registerAttributeEditLogBypass( entMan, cli.fullName,
                                              "enabled",
                                              "bool",
                                              "set", None )
