# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AirStreamLib
import CliSession
import GnmiSetCliSession
import Tac
from Toggles.EbraToggleLib import toggleOpenConfigGratuitousArpAcceptedEnabled

def Plugin( entMan ):
   class ToNativeEbraHandler( GnmiSetCliSession.PreCommitHandler ):
      externalPathList = [ "ip/openconfig/subintf/ipv4/ipIntfConfig" ]
      nativePathList = [ "ip/config", "l3/intf/config", "interface/config/subintf" ]

      @classmethod
      def run( cls, sessionName ):

         externalConfig = AirStreamLib.getSessionEntity( entMan, sessionName,
            "ip/openconfig/subintf/ipv4/ipIntfConfig" )
         nativeConfig = AirStreamLib.getSessionEntity( entMan, sessionName,
            "ip/config" )
         l3ConfigDir = AirStreamLib.getSessionEntity( entMan, sessionName,
            "l3/intf/config" )
         subIntfConfigDir = AirStreamLib.getSessionEntity( entMan, sessionName,
            "interface/config/subintf" )
         helper = Tac.newInstance( "Ebra::EbraOpenConfigHelper",
            externalConfig, nativeConfig, l3ConfigDir, subIntfConfigDir )
         helper.syncExternalToNative()

   if toggleOpenConfigGratuitousArpAcceptedEnabled():
      CliSession.registerConfigGroup( entMan,
                                    "airstream-cmv",
                                    "ip/openconfig/subintf/ipv4/ipIntfConfig" )
      GnmiSetCliSession.registerPreCommitHandler( ToNativeEbraHandler )
      AirStreamLib.registerCopyHandler( entMan, "OcIpv4SubInterfaceConfig",
         typeName="Ebra::OpenConfig" )
