# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import GnmiSetCliSession
import Tac
import AirStreamLib
import Tracing
from Toggles import EvpnToggleLib

t0 = Tracing.Handle( "ConfigSessionEvpn" ).trace0
t9 = Tracing.Handle( "ConfigSessionEvpn" ).trace9

def Plugin( entMan ):
   config = entMan.lookup( 'routing/bgp/config' )
   CliSession.registerAttributeEditLogBypass( entMan, config.fullName,
         "evpnOismLegacy", "bool", "set" )
   CliSession.registerEntityCopyFilter( entMan, '',
                                        'Routing::Bgp::MacPlugin::EvpnConfig', 
                                        [ 'schedClearTime' ] )

   # Support for AirstreamLib for OpenConfig
   CliSession.registerConfigGroup( entMan, "airstream-cmv",
         "evpn/openconfig/evpnInstances" )

   def toNativeEvpnInstanceSyncher( cls, sessionName ):
      evpnInstanceDir = AirStreamLib.getSessionEntity( entMan, sessionName,
                           "evpn/openconfig/evpnInstances" )
      macVrfConfigDir = AirStreamLib.getSessionEntity( entMan, sessionName,
            "routing/bgp/macvrf" )
      vtiConfigDir = AirStreamLib.getSessionEntity( entMan, sessionName,
            "interface/config/eth/vxlan" )

      t0( "Synching from " + str( evpnInstanceDir ) + " to " + str( vtiConfigDir ) )
      try:
         # Instantiate the SM which implements the precommit handler
         Tac.newInstance( 'EvpnOC::EvpnOcToEosSm', macVrfConfigDir,
               evpnInstanceDir, vtiConfigDir )
      except Exception as e: # pylint: disable-msg=W0703
         raise AirStreamLib.ToNativeSyncherError( sessionName,
               cls.__name__ + '::toNativeEvpnInstanceSyncher', str( e ) )

   # Register one-time-sync callback to be called before commit
   class ToNativeEvpnInstanceSyncher( GnmiSetCliSession.PreCommitHandler ):
      externalPathList = [ 'evpn/openconfig/evpnInstances',
                           'routing/bgp/macvrf' ]
      nativePathList = [ 'interface/config/eth/vxlan' ]
      @classmethod
      def run( cls, sessionName ):
         toNativeEvpnInstanceSyncher( cls, sessionName )

   if EvpnToggleLib.toggleEvpnAirStreamEnabled():
      GnmiSetCliSession.registerPreCommitHandler( ToNativeEvpnInstanceSyncher )

      AirStreamLib.registerCopyHandler( entMan, "EvpnInstance",
                                        typeName="EvpnOC::OCEvpnInstanceDir" )
