# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliSession

def Plugin( entMan ):
   policyConfig = entMan.lookup( "flowspec/policy/config" )

   CliSession.registerEntityCopyFilter( entMan,
                                        "", "Flowspec::FlowspecPolicyConfig", [],
                                        orderedAttrsBefore=[ "actions" ] )
   # Custom Copy handler for Config
   fpCopyHandlerDir = CliSession.registerCopyHandlerDir( entMan,
         "FlowspecPolicyConfig", "Flowspec::FlowspecPolicyCopyHandlerDir" )
   fpCopyHandlerDir.fpCopyHandler = ()
   fpCopyHandlerDir.fpCopyHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan, "",
                                         "Flowspec::FlowspecPolicyConfig",
                                         fpCopyHandlerDir.fpCopyHandler )

   # Ignore attribute changes in this path.
   fpActionPath = policyConfig.fullName + ".actions"
   fpPmapPath = policyConfig.fullName + ".pmapType.pmap"

   CliSession.registerAttributeEditLogBypass( entMan, fpActionPath,
                                              "", "", "set", None )
   CliSession.registerAttributeEditLogBypass( entMan, fpActionPath,
                                              "", "", "del", None )
   CliSession.registerAttributeEditLogBypass( entMan, fpPmapPath,
                                              "", "", "set", None )
