# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins
from Arnet import IpGenAddr

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   snoopConfig = entMan.lookup( 'bridging/igmpsnooping/config' )

   attrEditBypassParentDir = CliSession.attributeEditBypassDir( entMan )
   vlanConfigDefault = None
   querierConfigDefault = None
   intfConfigDefault = None
   ipGroupDefault = None
   if attrEditBypassParentDir:
      dummyIgmpSnConfig = attrEditBypassParentDir.newEntity(
         "Bridging::IgmpSnooping::Config", "DummyIgmpSnConfig" ) 
      vlanConfigDefault = dummyIgmpSnConfig.vlanConfig.newMember( 4094 )
      querierConfigDefault = vlanConfigDefault.vlanQuerierConfig = ()
      ipGroupDefault = vlanConfigDefault.ipGroup.newMember( IpGenAddr( '0.0.0.0' ) )
      intfConfigDefault = dummyIgmpSnConfig.intfConfig.newMember( "" )

   CliSession.registerAttributeEditLogBypass( 
      entMan, snoopConfig.fullName, "vlanConfig",
      "Bridging::IgmpSnooping::VlanConfig", "del", vlanConfigDefault )

   CliSession.registerAttributeEditLogBypass( 
      entMan, snoopConfig.fullName, "vlanQuerierConfig", 
      "Bridging::IgmpSnooping::VlanQuerierConfig", "del", querierConfigDefault )

   CliSession.registerAttributeEditLogBypass( 
      entMan, snoopConfig.fullName, "intfConfig", 
      "Bridging::IgmpSnooping::IntfConfig", "del", intfConfigDefault )

   CliSession.registerAttributeEditLogBypass( 
      entMan, snoopConfig.fullName, "ipGroup", 
      "Bridging::IgmpSnooping::IpGroup", "del", ipGroupDefault )
