# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   intfGroupCfg = entMan.lookup( 'group/config/interface' )

   # Groups configured for dynamic units won't show up in running config. So, add a
   # log by pass filter to take care of this
   CliSession.registerAttributeEditLogBypass(
      entMan, intfGroupCfg.fullName, 'config',
      'IntfGroup::Config', 'del' )
