# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   routerAdvtConfig = entMan.lookup( "routing6/routerAdvt/config" )

   attrEditBypassParentDir = CliSession.attributeEditBypassDir( entMan )
   intfDefault = None
   if attrEditBypassParentDir:
      # Create a RouterAdvt::Config to hold a default RouterAdvt::IntfConfig, which
      # will be used in debug-attribute to compare with deleted entities
      defaultConfig = attrEditBypassParentDir.newEntity( "RouterAdvt::Config",
                                                         "DefaultRouterAdvtConfig" )
      intfDefault = defaultConfig.intf.newMember( "" )
   CliSession.registerAttributeEditLogBypass( entMan, routerAdvtConfig.fullName,
                                              "intf", "RouterAdvt::IntfConfig",
                                              "del", intfDefault )
