# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   config = entMan.lookup( 'mgmtGnmiClient/config' )
   # we need to add the attribute edit log bypass due to the randomness of
   # "SecretCliLib::Secret" attributes salt and initial vector.
   for action in [ 'set', 'del' ]:
      CliSession.registerAttributeEditLogBypass( entMan, config.fullName,
                                                 'gnmiServer',
                                                 'MgmtGnmiClient::GnmiServer',
                                                 action )
