# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import PbrLib

def Plugin( entMan ):
   config = entMan.lookup( PbrLib.pbrConfigPath )

   # To prevent execessive reprogramming resulting from a config-session, the
   # following dependency between the intf config and pmap config is registered such
   # that the interface configuration is copied _first_.
   CliSession.registerConfigRootDependency( entMan, "pbr/input/pmap/cli",
                                            "pbr/input/intf/cli" )
   # The reason we use entityCopyFilter is that it adds the orderedAttrsBefore to the
   # copied() collection to allow the ptrs to pbrActions in pmapType to be resolved,
   # rather than deferred.
   CliSession.registerEntityCopyFilter( entMan,
                                        "", "Pbr::PbrConfig", [],
                                        orderedAttrsBefore=[ "pbrActions",
                                                             "cmapType" ])
   # Custom Copy handler for Config
   pbrCopyHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                                    "PbrConfig",
                                                    "Pbr::ConfigCopyHandlerDir" )
   pbrCopyHandlerDir.configHandler = ( )
   CliSession.registerCustomCopyHandler( entMan, "",
                                         "Pbr::PbrConfig",
                                         pbrCopyHandlerDir.configHandler )

   # Ignore attribute changes in this path.
   pbrActionPath = config.fullName + ".pbrActions"
   pbrPmapPath = config.fullName + ".pmapType.pmap"
   CliSession.registerAttributeEditLogBypass( entMan, pbrActionPath,
                                              "", "", "set", None )
   CliSession.registerAttributeEditLogBypass( entMan, pbrActionPath,
                                              "", "", "del", None )
   CliSession.registerAttributeEditLogBypass( entMan, pbrPmapPath,
                                              "", "", "set", None )
   pbrCmapPath = config.fullName + ".cmapType.cmap"
   CliSession.registerAttributeEditLogBypass( entMan, pbrCmapPath,
                                              "", "", "set", None )
   CliSession.registerAttributeEditLogBypass( entMan, pbrCmapPath,
                                              "", "", "del", None )
