# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   # EntityCopy handler
   # Custom EntityCopy handlers for PolicyMap types
   policyHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                         "QosPolicyMap",
                                         "Qos::PolicyMapCopyHandlerDir" )
   policyHandlerDir.copyHandler = ()
   policyHandler = policyHandlerDir.copyHandler
   policyHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         "",
                                         "Qos::PolicyMapConfig",
                                         policyHandler )
   classHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                         "QosClassMap",
                                         "Qos::ClassMapCopyHandlerDir" )
   classHandlerDir.copyHandler = ()
   classHandler = classHandlerDir.copyHandler
   classHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         "",
                                         "Qos::ClassMapConfig",
                                         classHandler )

   pdpCfg = entMan.lookup( "qos/acl/input/defaultPdpPmapCfg" )
   CliSession.registerAttributeEditLogBypass( entMan,
                                              pdpCfg.fullName,
                                              "pmap",
                                              "Qos::PolicyMapConfig",
                                              "del" )
   cliConfig = entMan.lookup( "qos/acl/input/cli" )
   CliSession.registerAttributeEditLogBypass( entMan,
                                              cliConfig.namedPolicer.fullName,
                                              "uniqueId",
                                              "Qos::UniqueId",
                                              "set" )
