# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import QosOpenConfigQueueManagementProfiles
import QosOpenConfigSchedulerPolicies
import QosOpenConfigClassifierConfig

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   # register handlers
   QosOpenConfigQueueManagementProfiles.registerQueueManagementProfilesHandler(
      entMan )
   QosOpenConfigSchedulerPolicies.registerSchedulerPoliciesHandler( entMan )
   QosOpenConfigClassifierConfig.registerClassifiersHandler( entMan )
