# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins
import AirStreamLib

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   prefix = "qos/openconfig/config/"
   paths = (
      prefix + "queues",
      prefix + "forwardingGroups",
      prefix + "classifiers",
      prefix + "interfaces",
      prefix + "schedulerPolicies",
      prefix + "queueManagementProfiles",
      prefix + "pfc",
   )

   for p in paths:
      CliSession.registerConfigGroup( entMan, "airstream-cmv", p )
      copyHandlerName = "Qos-" + p
      AirStreamLib.registerCopyHandler( entMan, copyHandlerName, path=p,
            commitExternal=( p.endswith( "/classifiers" ) or
               p.endswith( "/pfc" ) or p.endswith( "/interfaces" ) ) )
