# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   # -------------------------------------------------------------------------
   # Custom entity copy handlers
   # -------------------------------------------------------------------------
   rcfCopyHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                                          "Rcf",
                                                          "Rcf::RcfCopyHandlerDir" )
   rcfCopyHandlerDir.copyHandler = ()
   rcfCopyHandler = rcfCopyHandlerDir.copyHandler
   rcfCopyHandler.initialize()

   config = entMan.lookup( 'routing/rcf/config' )
   configTagToCodeUnitPath = config.configTagToCodeUnit.fullName

   CliSession.registerCustomCopyHandler( entMan,
                                         "",
                                         "Rcf::Config",
                                         rcfCopyHandler )

   # The codeUnitToConfigTag and configTagToCodeUnit mappings are expected to be
   # modified as a new tagId is created for config tags when they are recreated
   # when committing a config session.
   CliSession.registerAttributeEditLogBypass( entMan, config.fullName,
                                              "codeUnitToConfigTag",
                                              "ConfigTag::ConfigTagId", "set" )
   CliSession.registerAttributeEditLogBypass( entMan, config.fullName,
                                              "codeUnitToConfigTag",
                                              "ConfigTag::ConfigTagId", "del" )
   CliSession.registerAttributeEditLogBypass( entMan, config.fullName,
                                              "configTagToCodeUnit",
                                              "Rcf::ConfigTagToCodeUnit", "set" )
   CliSession.registerAttributeEditLogBypass( entMan, config.fullName,
                                              "configTagToCodeUnit",
                                              "Rcf::ConfigTagToCodeUnit", "del" )
   CliSession.registerAttributeEditLogBypass( entMan, configTagToCodeUnitPath,
                                              "codeUnit", "bool", "set" )
