# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliSession

def Plugin( entMan ):
   serverProbeCliConfig = entMan.lookup( "serverProbe/config" )
   protocolConfigPath = serverProbeCliConfig.fullName + ".protocolConfig"

   # we need to add the attribute edit log bypass due to the randomness of
   # "SecretCliLib::Secret" attributes salt and initial vector.

   CliSession.registerAttributeEditLogBypass( entMan, protocolConfigPath,
         "radiusAccessRequestKey", "ServerProbe::RadiusAccessRequestKey", "set" )
   CliSession.registerAttributeEditLogBypass( entMan, protocolConfigPath,
         "radiusAccessRequestKey", "ServerProbe::RadiusAccessRequestKey", "del" )
