# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   config = entMan.lookup( "mgmt/security/sh-sec-prof/config" )
   profilePath = config.fullName + ".profile"
   # we need to add the attribute edit log bypass due to the randomness of
   # "SecretCliLib::Secret" attributes salt and initial vector.
   # "Mgmt::Security::SharedSecretProfile::SecretConfig" is nested collection,
   # we need to use "bool" as attrType
   for action in [ "set", "del" ]:
      secretType = "Mgmt::Security::SharedSecretProfile::SecretConfig"
      CliSession.registerAttributeEditLogBypass( entMan, profilePath, "secret",
                                                 secretType, action )

   # -------------------------------------------------------------------------
   # Custom entity copy handlers
   # -------------------------------------------------------------------------
   sspHandlerDir = CliSession.registerCopyHandlerDir(
      entMan, "SharedSecretProfile",
      "Mgmt::Security::SharedSecretProfile::SharedSecretProfileCopyHandlerDir" )
   sspHandlerDir.copyHandler = ()
   sspHandler = sspHandlerDir.copyHandler
   sspHandler.initialize()

   CliSession.registerCustomCopyHandler(
      entMan, "", "Mgmt::Security::SharedSecretProfile::Config", sspHandler )
